﻿<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    public class Params : ContextBase {
        public Params(Context context) : base(context) {
            okres = GetOkres();
        }

        TypNagrodyKary typNK;
        [Caption("Typ")]
        [Priority(10)]
        [DefaultWidth(21)]
        public TypNagrodyKary TypNK {
            get { return typNK; }
            set {
                typNK = value;
                OnChanged(EventArgs.Empty);
            }
        }

        DefinicjaNagrodyKary[] definicjaN;
        [Caption("Definicja nagrody")]
        [Priority(20)]
        public DefinicjaNagrodyKary[] DefinicjaN {
            get { return definicjaN; }
            set {
                definicjaN = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListDefinicjaN() {
            KadryModule kadry = KadryModule.GetInstance(this);
            Soneta.Business.View v = kadry.DefNagrodKar.WgNazwy.CreateView();
            v.Condition &= new FieldCondition.Equal("Typ", TypNagrodyKary.Nagroda);
            v.Condition &= new FieldCondition.NotEqual("Blokada", true);
            return v;
        }

        public bool IsReadOnlyDefinicjaN() {
			if (typNK != TypNagrodyKary.Kara)
				return false;
			return true;
        }

        DefinicjaNagrodyKary[] definicjaK;
        [Caption("Definicja kary")]
        [Priority(30)]
        public DefinicjaNagrodyKary[] DefinicjaK {
            get { return definicjaK; }
            set {
                definicjaK = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListDefinicjaK() {
            KadryModule kadry = KadryModule.GetInstance(this);
            Soneta.Business.View v = kadry.DefNagrodKar.WgNazwy.CreateView();
            v.Condition &= new FieldCondition.Equal("Typ", TypNagrodyKary.Kara);
            v.Condition &= new FieldCondition.NotEqual("Blokada", true);
            return v;
        }

        public bool IsReadOnlyDefinicjaK() {
			if (typNK != TypNagrodyKary.Nagroda)
				return false;
			return true;
        }
       
        FromTo okres;
        [Required]
        [Caption("Okres")]
        [Priority(40)]
        public FromTo Okres {
            get { return okres; }
            set {
                if (value == FromTo.Empty)
                    value = GetOkres();
                okres = value;
                OnChanged(EventArgs.Empty);
            }
        }

        FromTo GetOkres() {
            return new YearMonth(ActualDate.Today(Context)).ToFromTo();
        }
    }

    Params pars = null;
    [Context(Required = true)]
    public Params Prm {
        set { pars = value; }
    }

    protected void dc_ContextLoad(object sender, EventArgs e) {
        ReportHeader["OKRES"] = pars.Okres.ToString();
		if (pars.TypNK == 0)
			ReportHeader["TYP"] = "nagród i kar";
		else if (pars.TypNK == TypNagrodyKary.Nagroda)
			ReportHeader["TYP"] = "nagród";
		else
			ReportHeader["TYP"] = "kar";

        ArrayList lista = new ArrayList();
        Row[] rows = (Row[])dc[typeof(Row[])];

        RowCondition condition = RowCondition.Empty;
        if (pars.TypNK != 0)
            condition &= new FieldCondition.Equal("Typ", pars.TypNK);
        if ((pars.TypNK == 0 || pars.TypNK == TypNagrodyKary.Nagroda) && pars.DefinicjaN != null && pars.DefinicjaN.Length > 0)
            condition &= new FieldCondition.In("Definicja", pars.DefinicjaN);
        if ((pars.TypNK == 0 || pars.TypNK == TypNagrodyKary.Kara) && pars.DefinicjaK != null && pars.DefinicjaK.Length > 0)
            condition &= new FieldCondition.In("Definicja", pars.DefinicjaK);
        condition &= new FieldCondition.Contain("Data", pars.Okres);

        bool UI = rows.Length > 0 ? (rows[0] is Pracownik) : false;
        if (UI) {
            foreach (Pracownik p in rows) {
                SubTable st = p.NagrodyKary;
                st = st[condition];
                foreach (NagrodaKara nk in st)
                    lista.Add(nk);
            }
        }
        else {
            SubTable st = KadryModule.GetInstance(dc).NagrodyKary.WgPracownik;
            st = st[condition];
            foreach (NagrodaKara nk in st)
                lista.Add(nk);
        }

        Grid1.DataSource = lista;
    }

    protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
        NagrodaKara nk = (NagrodaKara)args.Row;

        colNazwisko.EditValue = nk.Pracownik.Nazwisko;
        colImie.EditValue = nk.Pracownik.Imie;        
        colNazwa.EditValue = nk.Nazwa;
        colRodzaj.EditValue = nk.Rozliczenie.Element;
        colDataP.EditValue = nk.Data;
        if (nk.Typ == TypNagrodyKary.Kara) {
            Kara kr = (Kara)nk;
            colDataA.EditValue = kr.DataAnulowania;
        }
        colKwota.EditValue = nk.Rozliczenie.Kwota;
        colUwagi.EditValue = nk.Opis;
        colTyp.EditValue = nk.Typ;
    }

    public static void Msg(object value) {
    }
    
</script>

<HTML>
	<HEAD>
		<TITLE>Nagrody i kary</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad" Landscape="True"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" 
                title="Zestawienie %TYP% za okres %OKRES%"></eb:ReportHeader>
			<ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.KadryPlace" onbeforerow="Grid1_BeforeRow">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" VAlign="Middle" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" VAlign="Middle" ID="colNazwisko" Caption="Nazwisko"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" VAlign="Middle" ID="colImie" Caption="Imie" Width="16"></ea:GridColumn>
					<ea:GridColumn runat="server" ID="colTyp" Align="Left" VAlign="Top" Caption="Typ" Width="10"></ea:GridColumn>
					<ea:GridColumn runat="server" ID="colNazwa" Align="Left" VAlign="Top" Caption="Nazwa" Width="26"></ea:GridColumn>
					<ea:GridColumn runat="server" ID="colRodzaj" Align="Left" VAlign="Top" Caption="Rodzaj" Width="14"></ea:GridColumn>
					<ea:GridColumn runat="server" ID="colDataP" Align="Right" VAlign="Top" Caption="Data przyznania" Width="14"></ea:GridColumn>
					<ea:GridColumn runat="server" ID="colDataA" Align="Right" VAlign="Top" Caption="Data anulowania" Width="14"></ea:GridColumn>
					<ea:GridColumn runat="server" ID="colKwota" Align="Right" VAlign="Top" Caption="Kwota" Width="12"></ea:GridColumn>
					<ea:GridColumn runat="server" ID="colUwagi" Align="Left" VAlign="Top" Caption="Uwagi" Width="30"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>
